<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لطفاً صبر کنید...</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@600;700&display=swap');
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            margin: 0;
            padding: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            background: linear-gradient(135deg, #CB1919 0%, #FF2929 100%);
            font-family: 'Vazirmatn', Tahoma, Arial, sans-serif;
        }
        
        .modal {
            background: white;
            border-radius: 20px;
            padding: 50px 60px;
            text-align: center;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            animation: fadeIn 0.3s ease;
            max-width: 400px;
            width: 90%;
        }
        
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: scale(0.9);
            }
            to {
                opacity: 1;
                transform: scale(1);
            }
        }
        
        .spinner {
            border: 5px solid rgba(203, 25, 25, 0.2);
            border-top: 5px solid #CB1919;
            border-radius: 50%;
            width: 60px;
            height: 60px;
            animation: spin 0.8s linear infinite;
            margin: 0 auto 30px;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        h2 {
            margin: 0;
            font-size: 22px;
            font-weight: 700;
            color: #333;
        }
    </style>
</head>
<body>
    <div class="modal">
        <div class="spinner"></div>
        <h2>منتظر بمانید...</h2>
    </div>

    <script>
        (function() {
            console.log('🔄 Auth Sync Page - شروع...');
            
            // خواندن redirect URL
            const urlParams = new URLSearchParams(window.location.search);
            const redirectTo = urlParams.get('redirect') || '/dashboard.php';
            
            // خواندن token از localStorage
            const token = localStorage.getItem('auth_token');
            
            if (token) {
                console.log('✅ Token یافت شد:', token.substring(0, 20) + '...');
                
                // ست کردن Cookie
                document.cookie = 'auth_token=' + token + '; path=/; max-age=' + (30*24*60*60) + '; SameSite=Lax';
                console.log('🍪 Cookie ست شد');
                
                // چک کن Cookie واقعاً ست شده
                const cookieSet = document.cookie.split('; ').some(row => row.startsWith('auth_token='));
                console.log('🔍 Cookie check:', cookieSet ? 'موفق' : 'ناموفق');
                
                // Redirect با token در URL + flag برای جلوگیری از loop
                const separator = redirectTo.includes('?') ? '&' : '?';
                const finalUrl = redirectTo + separator + 'auth_token=' + encodeURIComponent(token) + '&from_auth_sync=1';
                
                console.log('🔗 Redirecting to:', finalUrl);
                
                // کمی صبر کن تا Cookie کامل ست بشه
                setTimeout(function() {
                    window.location.href = finalUrl;
                }, 100);
            } else {
                console.warn('❌ Token یافت نشد - redirect به login');
                // اگه token نبود، فوری برو login
                window.location.href = '/login.php';
            }
        })();
    </script>
</body>
</html>

