<?php
/**
 * صفحه مشاهده وضعیت سیستم خودکار چک مصرف
 */

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';

requireAdmin();

$lastCheckFile = __DIR__ . '/../logs/last-usage-check.txt';
$lastCheck = file_exists($lastCheckFile) ? (int) file_get_contents($lastCheckFile) : 0;
$nextCheck = $lastCheck + (6 * 3600); // 6 ساعت بعد
$checkInterval = 6; // ساعت

// ریست کردن زمان
if (isset($_POST['reset_timer'])) {
    @unlink($lastCheckFile);
    header('Location: auto-check-status.php?reset=1');
    exit;
}

// اجرای فوری
if (isset($_POST['run_now'])) {
    @unlink($lastCheckFile);
    header('Location: /cron-check-usage.php?key=esim_cron_2024_secret');
    exit;
}

// تغییر interval
if (isset($_POST['change_interval'])) {
    $newInterval = intval($_POST['interval']);
    if ($newInterval >= 1 && $newInterval <= 24) {
        $autoCheckFile = __DIR__ . '/../auto-check-usage.php';
        $content = file_get_contents($autoCheckFile);
        $content = preg_replace(
            "/define\('CHECK_INTERVAL_HOURS', \d+\);/",
            "define('CHECK_INTERVAL_HOURS', $newInterval);",
            $content
        );
        file_put_contents($autoCheckFile, $content);
        $checkInterval = $newInterval;
        $success = "بازه زمانی به $newInterval ساعت تغییر کرد";
    }
}

// خواندن interval فعلی
$autoCheckFile = __DIR__ . '/../auto-check-usage.php';
if (file_exists($autoCheckFile)) {
    $content = file_get_contents($autoCheckFile);
    if (preg_match("/define\('CHECK_INTERVAL_HOURS', (\d+)\);/", $content, $matches)) {
        $checkInterval = (int) $matches[1];
    }
}

?>
<!DOCTYPE html>
<html dir="rtl" lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>وضعیت سیستم چک مصرف</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Vazirmatn', Tahoma, sans-serif; }
        body { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; padding: 30px; }
        .container { max-width: 800px; margin: 0 auto; }
        h1 { color: white; text-align: center; margin-bottom: 30px; text-shadow: 0 2px 10px rgba(0,0,0,0.2); }
        .card { background: white; border-radius: 20px; padding: 30px; margin-bottom: 20px; box-shadow: 0 10px 40px rgba(0,0,0,0.2); }
        .status-box { display: flex; align-items: center; gap: 20px; padding: 20px; border-radius: 15px; margin-bottom: 20px; }
        .status-box.active { background: linear-gradient(135deg, #10b981 0%, #059669 100%); color: white; }
        .status-box.waiting { background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); color: white; }
        .status-icon { width: 60px; height: 60px; background: rgba(255,255,255,0.2); border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 24px; }
        .status-text h3 { font-size: 1.3rem; margin-bottom: 5px; }
        .status-text p { opacity: 0.9; }
        .info-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-bottom: 20px; }
        .info-item { background: #f8f9fa; padding: 20px; border-radius: 12px; text-align: center; }
        .info-item .value { font-size: 2rem; font-weight: 700; color: #667eea; }
        .info-item .label { color: #666; margin-top: 5px; }
        .btn { padding: 12px 25px; border: none; border-radius: 10px; font-size: 15px; font-weight: 600; cursor: pointer; transition: all 0.3s; display: inline-flex; align-items: center; gap: 8px; }
        .btn:hover { transform: translateY(-2px); }
        .btn-primary { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; }
        .btn-warning { background: #f59e0b; color: white; }
        .btn-danger { background: #dc3545; color: white; }
        .btn-success { background: #10b981; color: white; }
        .form-row { display: flex; gap: 10px; align-items: center; margin-top: 20px; }
        .form-row select { padding: 12px 15px; border: 2px solid #e0e0e0; border-radius: 10px; font-size: 15px; }
        .back-link { color: white; text-decoration: none; display: inline-flex; align-items: center; gap: 8px; margin-bottom: 20px; }
        .back-link:hover { text-decoration: underline; }
        .success-msg { background: #d4edda; border: 1px solid #c3e6cb; color: #155724; padding: 15px; border-radius: 10px; margin-bottom: 20px; }
        .countdown { font-size: 1.5rem; font-weight: 700; color: #667eea; }
        .how-it-works { background: #e8f4fd; border-radius: 12px; padding: 20px; margin-top: 20px; }
        .how-it-works h4 { color: #1e40af; margin-bottom: 15px; }
        .how-it-works ul { list-style: none; }
        .how-it-works li { padding: 8px 0; color: #1e40af; display: flex; align-items: center; gap: 10px; }
        .how-it-works li i { color: #10b981; }
    </style>
</head>
<body>
    <div class="container">
        <a href="/admin/esims.php" class="back-link">
            <i class="fas fa-arrow-right"></i>
            بازگشت به مدیریت eSIM ها
        </a>
        
        <h1><i class="fas fa-robot"></i> سیستم خودکار چک مصرف</h1>
        
        <?php if (isset($_GET['reset'])): ?>
        <div class="success-msg">
            <i class="fas fa-check-circle"></i>
            زمان‌بندی ریست شد. در بازدید بعدی سایت اجرا می‌شود.
        </div>
        <?php endif; ?>
        
        <?php if (isset($success)): ?>
        <div class="success-msg">
            <i class="fas fa-check-circle"></i>
            <?php echo $success; ?>
        </div>
        <?php endif; ?>
        
        <div class="card">
            <div class="status-box <?php echo (time() >= $nextCheck || $lastCheck == 0) ? 'active' : 'waiting'; ?>">
                <div class="status-icon">
                    <i class="fas <?php echo (time() >= $nextCheck || $lastCheck == 0) ? 'fa-play' : 'fa-clock'; ?>"></i>
                </div>
                <div class="status-text">
                    <?php if ($lastCheck == 0): ?>
                        <h3>🚀 آماده اجرا</h3>
                        <p>سیستم هنوز اجرا نشده. در اولین بازدید از سایت اجرا می‌شود.</p>
                    <?php elseif (time() >= $nextCheck): ?>
                        <h3>✅ آماده اجرای مجدد</h3>
                        <p>زمان اجرای بعدی رسیده. در بازدید بعدی از سایت اجرا می‌شود.</p>
                    <?php else: ?>
                        <h3>⏳ در انتظار...</h3>
                        <p>اجرای بعدی: <?php echo date('Y/m/d H:i', $nextCheck); ?></p>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="info-grid">
                <div class="info-item">
                    <div class="value"><?php echo $checkInterval; ?>h</div>
                    <div class="label">بازه زمانی</div>
                </div>
                <div class="info-item">
                    <div class="value"><?php echo $lastCheck ? date('H:i', $lastCheck) : '-'; ?></div>
                    <div class="label">آخرین اجرا</div>
                </div>
                <div class="info-item">
                    <div class="value" id="countdown">-</div>
                    <div class="label">تا اجرای بعدی</div>
                </div>
            </div>
            
            <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                <form method="POST" style="display:inline;">
                    <button type="submit" name="run_now" class="btn btn-success">
                        <i class="fas fa-play"></i>
                        اجرای فوری
                    </button>
                </form>
                
                <form method="POST" style="display:inline;">
                    <button type="submit" name="reset_timer" class="btn btn-warning">
                        <i class="fas fa-undo"></i>
                        ریست زمان‌بندی
                    </button>
                </form>
                
                <a href="/admin/usage-alerts.php" class="btn btn-primary">
                    <i class="fas fa-bell"></i>
                    مشاهده اعلان‌ها
                </a>
            </div>
            
            <form method="POST" class="form-row">
                <label>تغییر بازه زمانی:</label>
                <select name="interval">
                    <?php for ($i = 1; $i <= 24; $i++): ?>
                    <option value="<?php echo $i; ?>" <?php echo $i == $checkInterval ? 'selected' : ''; ?>>
                        <?php echo $i; ?> ساعت
                    </option>
                    <?php endfor; ?>
                </select>
                <button type="submit" name="change_interval" class="btn btn-primary">
                    <i class="fas fa-save"></i>
                    ذخیره
                </button>
            </form>
        </div>
        
        <div class="card">
            <div class="how-it-works">
                <h4><i class="fas fa-info-circle"></i> این سیستم چطور کار می‌کنه؟</h4>
                <ul>
                    <li><i class="fas fa-check"></i> بدون نیاز به Cron Job کار می‌کنه</li>
                    <li><i class="fas fa-check"></i> هر بار که یه کاربر از سایت بازدید می‌کنه، چک می‌کنه آیا زمان اجرا رسیده یا نه</li>
                    <li><i class="fas fa-check"></i> اگر زمان رسیده باشه، در پس‌زمینه اجرا می‌شه (کاربر متوجه نمیشه)</li>
                    <li><i class="fas fa-check"></i> eSIM هایی که زیر 10% حجم دارن، پیامک می‌گیرن</li>
                    <li><i class="fas fa-check"></i> هر eSIM فقط یکبار اعلان می‌گیره</li>
                </ul>
            </div>
        </div>
    </div>
    
    <script>
    // شمارش معکوس
    const nextCheck = <?php echo $nextCheck; ?>;
    const lastCheck = <?php echo $lastCheck; ?>;
    
    function updateCountdown() {
        const now = Math.floor(Date.now() / 1000);
        const remaining = nextCheck - now;
        const el = document.getElementById('countdown');
        
        if (lastCheck == 0) {
            el.textContent = 'اولین بازدید';
        } else if (remaining <= 0) {
            el.textContent = 'آماده!';
        } else {
            const hours = Math.floor(remaining / 3600);
            const mins = Math.floor((remaining % 3600) / 60);
            el.textContent = `${hours}:${String(mins).padStart(2, '0')}`;
        }
    }
    
    updateCountdown();
    setInterval(updateCountdown, 60000);
    </script>
</body>
</html>

